/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWEventDefinition
extends VWMLABase
implements Serializable {
    private static final long serialVersionUID = 7458L;
    private String[][] assignments = null;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;
    private String workClassName = null;
    private String callIS = null;
    private String op = null;
    private String val = null;
    private VWWFEInstruction myWFEInstruction = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-12-11 00:35:32 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWEventDefinition() {
    }

    protected VWEventDefinition(VWWFEInstruction wfe, String theWorkClassName, String theOperator, String theValue) throws VWException {
        this.setWorkClassName(theWorkClassName);
        this.setComparisonOperator(theOperator);
        this.setValue(theValue);
        this.myWFEInstruction = wfe;
    }

    public String getWorkClassName() {
        return this.translateStr(this.workClassName);
    }

    public void setWorkClassName(String theWorkClassName) throws VWException {
        if (theWorkClassName == null) {
            throw new VWException("vw.api.VWEventdefinitionNullWCName", "theWorkClassName parameter cannot be null.");
        }
        this.workClassName = theWorkClassName;
    }

    public String getValue() {
        return this.val;
    }

    public void setValue(String theValue) throws VWException {
        if (theValue == null) {
            throw new VWException("vw.api.VWEventdefinitionNullValue", "theValue parameter cannot be null.");
        }
        this.val = theValue;
    }

    public String getCallISName() {
        return this.translateStr(this.callIS);
    }

    public void setCallISName(String theCallISName) throws VWException {
        this.callIS = theCallISName;
    }

    public String getComparisonOperator() {
        return this.op;
    }

    public void setComparisonOperator(String theOperator) throws VWException {
        if (theOperator == null) {
            throw new VWException("vw.api.VWEventdefinitionNullOperator", "theOperator parameter cannot be null.");
        }
        if (!(theOperator.equals("=") || theOperator.equals(">") || theOperator.equals("<") || theOperator.equals("<>") || theOperator.equals("<=") || theOperator.equals(">="))) {
            throw new VWException("vw.api.VWEventdefinitionInvalidOperator", "theOperator parameter {0}, is invalid, should be one of these: =, >, <, <>, <=, or >=.", theOperator);
        }
        this.op = theOperator;
    }

    public String[][] getAssignments() {
        return this.assignments;
    }

    public void setAssignments(String[][] theAssignments) throws VWException {
        if (theAssignments != null) {
            for (int i = 0; i < theAssignments.length; ++i) {
                if (theAssignments[i].length != 2) {
                    throw new VWException("vw.api.VWEventDefinitionAssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(theAssignments[i].length));
                }
                if (theAssignments[i][0] != null && theAssignments[i][1] != null) continue;
                throw new VWException("vw.api.VWEventDefinitionAssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
            }
        }
        this.assignments = theAssignments;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWFEInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t\t<Event\n");
        if (this.workClassName != null) {
            theBuffer.append(ATTRIB_INDENT + "WCName=\"" + VWXMLHandler.toXMLString(this.workClassName) + "\"");
        }
        if (this.op != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Operator=\"" + VWXMLHandler.toXMLString(this.op) + "\"");
        }
        if (this.val != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Value=\"" + VWXMLHandler.toXMLString(this.val) + "\"");
        }
        if (this.callIS != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "CallIS=\"" + VWXMLHandler.toXMLString(this.callIS) + "\"");
        }
        theBuffer.append(">\n");
        if (this.assignments != null) {
            for (int i = 0; i < this.assignments.length; ++i) {
                theBuffer.append(ATTRIB_INDENT + "<Assign LVal=\"" + VWXMLHandler.toXMLString(this.assignments[i][0]) + "\" RVal=\"" + VWXMLHandler.toXMLString(this.assignments[i][1]) + "\"/>\n");
            }
        }
        theBuffer.append("\t\t\t\t</Event>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWFEInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<fn:Event\n");
        if (this.workClassName != null) {
            theBuffer.append(indentB + "WCName=\"" + VWXMLHandler.toXMLString(this.workClassName) + "\"");
        }
        if (this.op != null) {
            theBuffer.append("\n" + indentB + "Operator=\"" + VWXMLHandler.toXMLString(this.op) + "\"");
        }
        if (this.val != null) {
            theBuffer.append("\n" + indentB + "Value=\"" + VWXMLHandler.toXMLString(this.val) + "\"");
        }
        if (this.callIS != null) {
            theBuffer.append("\n" + indentB + "CallIS=\"" + VWXMLHandler.toXMLString(this.callIS) + "\"");
        }
        theBuffer.append(">\n");
        if (this.assignments != null) {
            for (int i = 0; i < this.assignments.length; ++i) {
                theBuffer.append(indentB + "<Assign LVal=\"" + VWXMLHandler.toXMLString(this.assignments[i][0]) + "\" RVal=\"" + VWXMLHandler.toXMLString(this.assignments[i][1]) + "\"/>\n");
            }
        }
        theBuffer.append(indentA + "</fn:Event>\n");
    }

    public void validate(VWSession theSession, VWWorkflowDefinition theWorkflow, Vector EDefVector, VWCompoundStepDefinition myStep, int instId, int eventId) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep, instId, eventId);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep, int instId, int eventId) throws VWException {
        block29: {
            int i;
            VWValidationError theError;
            VWString theMessage;
            boolean WCFound = false;
            VWWorkflowSignature theWaitedForClassSig = null;
            VWWorkflowSignature theWaitedForBaseClassSig = null;
            VWWorkflowCollectionDefinition myColl = myStep.getMap().getWorkflow().getWorkflowCollection();
            boolean usingLocalWC = false;
            VWWorkflowSignature myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            ++eventId;
            if (this.workClassName == null || this.workClassName.compareTo("") == 0) {
                theMessage = new VWString("vw.api.VWEventDefinitionWCNameIsNull", "Event number {0}, workclass name  value is null or empty", String.valueOf(eventId));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            } else {
                if (myColl != null && myColl.isExistingWorkflowName(this.workClassName, true) && myColl.getWorkflow(this.workClassName, true).getTransferFlag()) {
                    theWaitedForClassSig = myColl.getWorkflow(this.workClassName, true).getWorkflowSignature(validationContext);
                    usingLocalWC = true;
                    theWaitedForBaseClassSig = myColl.getWorkflow(this.workClassName, true).getBaseWorkflowSignature(validationContext);
                    WCFound = true;
                } else if (validationContext.getVWSession() != null) {
                    VWSession theSession = validationContext.getVWSession();
                    String[] WCNames = theSession.fetchWorkClassNames(true);
                    for (i = 0; i < WCNames.length; ++i) {
                        if (this.workClassName.compareTo(WCNames[i]) != 0) continue;
                        WCFound = true;
                        theWaitedForClassSig = theSession.fetchWorkflowSignature(this.workClassName);
                        break;
                    }
                }
                if (!WCFound) {
                    theMessage = new VWString("vw.api.VWEventDefinitionWCNameDoesntexist", "WaitForCondition instruction references work class, {0}, but no work class of that name was found with the transfer flag set in the workflow collection or on the server.", this.workClassName);
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                    validationContext.addValidationError(theError);
                }
            }
            if (!usingLocalWC) {
                theMessage = new VWString("vw.api.VWVWEventDefinitionWCnotInCollection", "WaitForCondition instruction references work class, {0}, but no work class of that  name was found with the transfer flag set in the workflow collection. Using the definition previously  transferred to the server.", this.workClassName);
                theError = new VWValidationError(7, 2, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            }
            if (!usingLocalWC && myColl != null && myColl.isExistingWorkflowName(this.workClassName, true) && !myColl.getWorkflow(this.workClassName, true).getTransferFlag()) {
                theMessage = new VWString("vw.api.VWVWEventDefinitionWCnotInCollection", "Wait for event is waiting for a work object whose WorkClass, {0}, exists in the workflow collection but it does not have the transfer flag set, using the definition previously transferred to the server.", this.workClassName);
                theError = new VWValidationError(7, 2, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            }
            if (this.op == null || this.op.compareTo("") == 0) {
                theMessage = new VWString("vw.api.VWEventDefinitionOpIsNull", "Event number {0}, operator value is null or empty", String.valueOf(eventId));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            } else if (!(this.op.equals("=") || this.op.equals(">") || this.op.equals("<") || this.op.equals("<>") || this.op.equals("<=") || this.op.equals(">="))) {
                theMessage = new VWString("vw.api.VWEventDefinitionOpIsInvalid", "Event number {0}, operator value, {1}, is not a valid operator", String.valueOf(eventId), this.op);
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            }
            if (this.val == null || this.val.compareTo("") == 0) {
                theMessage = new VWString("vw.api.VWEventDefinitionValueIsNull", "Event number {0}, value is null or empty", String.valueOf(eventId));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            } else if (WCFound) {
                VWCompiledExpr compRes = new VWCompiledExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(this.val, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    for (i = 0; i < theErrorStrings.length; ++i) {
                        VWString theMessage2 = new VWString("vw.api.VWEventDefinitionValueSyntaxErrors", "Event number {0}, Syntax error in event value expression: {1}", String.valueOf(eventId), theErrorStrings[i]);
                        VWValidationError theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                        validationContext.addValidationError(theError2);
                    }
                } else {
                    VWValidationError theError3;
                    if (theWaitedForClassSig != null && !VWFieldType.isCompatibleType(theWaitedForClassSig.getFTagType(), compRes.getResultType())) {
                        VWString theMessage3 = new VWString("vw.api.VWEventDefinitionIncompatibleExpressionType", "Event number {0}, event value expression type found {1}, expected {2}", String.valueOf(eventId), VWFieldType.typeToString(compRes.getResultType()), VWFieldType.typeToString(theWaitedForClassSig.getFTagType()));
                        theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                        validationContext.addValidationError(theError3);
                    }
                    if (compRes.getResultIsArray()) {
                        VWString theMessage4 = new VWString("vw.api.VWEventDefinitionMisMatchedArrayType", "Event number {0}, event value expression cannot be an array.", String.valueOf(eventId));
                        theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                        validationContext.addValidationError(theError3);
                    }
                }
            }
            if (this.assignments != null) {
                for (int i2 = 0; i2 < this.assignments.length; ++i2) {
                    VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                    String[] theErrorStrings = VWExpr.compileVWExpr(":=" + this.assignments[i2][0], myWflSignature, myBaseWflSignature, theWaitedForClassSig, theWaitedForBaseClassSig, true, lCompRes);
                    if (theErrorStrings != null) {
                        int errorCount = theErrorStrings.length;
                        for (int k = 0; k < errorCount; ++k) {
                            VWString theMessage5 = new VWString("vw.api.VWEventDefinitionAsgnBadLValue", "Event Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i2), this.assignments[i2][0], theErrorStrings[k]);
                            VWValidationError theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage5.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                            validationContext.addValidationError(theError4);
                        }
                        continue;
                    }
                    int expectedRValueType = lCompRes.getResultType();
                    boolean expectedRValueIsArray = lCompRes.getResultIsArray();
                    VWCompiledExpr rCompRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.assignments[i2][1], theWaitedForClassSig, theWaitedForBaseClassSig, myWflSignature, myBaseWflSignature, true, rCompRes);
                    if (theErrorStrings != null) {
                        int errorCount = theErrorStrings.length;
                        for (int j = 0; j < errorCount; ++j) {
                            VWString theMessage6 = new VWString("vw.api.VWEventDefinitionAsgnRValSyntaxError", "Event Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i2), VWFieldType.typeToString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                            VWValidationError theError5 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage6.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                            validationContext.addValidationError(theError5);
                        }
                        continue;
                    }
                    if (VWFieldType.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                    VWString theMessage7 = new VWString("VWEventDefinitionAsgnTypeMismatch", "Event Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i2), VWFieldType.typeToString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.typeToString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                    VWValidationError theError6 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(19), theMessage7.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                    validationContext.addValidationError(theError6);
                }
            }
            if (this.callIS != null && VWMapDefinition.mapNameToId(this.callIS) == 0) {
                try {
                    myStep.getMap().getWorkflow().getMap(this.callIS);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.callIS)) break block29;
                    VWString theMessage8 = new VWString("vw.api.VWEventDefinitionMapNotFound", "Event number {0}, The map to be called by the event, {1}, was not found in this or the parent workflow definition.", String.valueOf(eventId), this.callIS);
                    VWValidationError theError7 = new VWValidationError(7, 1, myStep.getName(), this.callIS, theMessage8.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                    validationContext.addValidationError(theError7);
                }
            }
        }
    }

    public VWSession getSession() throws VWException {
        if (this.myWFEInstruction != null && this.myWFEInstruction.getStep() != null && this.myWFEInstruction.getStep().getMap() != null && this.myWFEInstruction.getStep().getMap().getWorkflow() != null) {
            return this.myWFEInstruction.getStep().getMap().getWorkflow().getSession();
        }
        return null;
    }
}

